jQuery(function($){
	$("#botonLimpiarCriterios").click(function(){
		fncLimpiarCampos("#divCriteriosBusqueda");
		fncBuscar();
		fncOcultarValidaciones("#feedbackMensajes");
		fncOcultarValidaciones("#feedbackMensajesTablaIncoherencias");
		$("#first_pager").click();
	});
	
	//definición del acordeón de los criterios de búsqueda
	$("#divCriteriosBusqueda").rup_accordion({
		collapsible: true
	});
	
	//Creamos el área de mensajes del formulario
	$("#feedbackMensajes").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false,
		gotoTop: false
	});
	
	//Creamos el área de mensajes del formulario
	$("#feedbackMensajesTablaIncoherencias").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false,
		gotoTop: false
	});
	
	//Añadimos las funciones a los botones 
	$("#botonBuscar").click(fncBuscar);
	//al pulsar intro, que busque
	$("#FORMULARIO").keypress(function(event){
		if (event.which == 13){
			fncBuscar();
		}
	});
	
	$("#botonDeshabilitar").click(fncDeshabilitar);
	
	//Definición del grid de documentos
	$("#GRID_incoherencias").rup_grid({
		url: $.rup.CTX_PATH+"incoherencias/tabla",
		loadOnStartUp: false,
		pagerName: "pager",
		autowidth: true,
		rowNum: "10",
		multiselect: true,
		colNames: [
		    //$.rup.i18n.app.GRID_peticion.codExpediente,
		    "",
		    "Expediente",
		    "Incoherencia"
		],
		colModel: [
			{ name: "idIncoherencia", index: "2", width:"35%"},
			{ name: "codExpediente", index: "1"},
			{ name: "descTipoIncoherencia", index: "3"}
		]
	});//Fin definición del objeto tabla
});

/**
 * Función de búsqueda que recarga la tabla y envía los filtros al controller con una
 * petición ajax 
 */
function fncBuscar(){
	varCodExpediente = $("#codExpediente").attr("value");
	//Construimos el objeto con los parámetros del filtro a enviar

	var filtro = {
			codExpediente: varCodExpediente
	};

	//Le pasamos al objeto tabla el filtro
	$("#GRID_incoherencias").rup_grid("setGridParam",{postData: filtro});
	//Recargamos la tabla haciendo la petición al servidor
	$("#GRID_incoherencias").rup_grid("reloadGrid");
	
	fncOcultarValidaciones("#feedbackMensajes");
	fncOcultarValidaciones("#feedbackMensajesTablaIncoherencias");
	$("#first_pager").click();
	$("#GRID_incoherencias").rup_grid("resetSelection");

}

function fncDeshabilitar() {
	
	var arrayFilas = $("#GRID_incoherencias").rup_grid("getGridParam","selarrrow");
	var arrayLength = arrayFilas.length;
	var numFila = 0;
	if (arrayLength > 0) {
		for (var i = 0; i < arrayLength; i++) {
			numFila = arrayFilas[i];
			//Obtenemos el número de fila seleccionada
			if(numFila && numFila>0){
				//Obtenemos los datos de la fila seleccionada
				var filaIncoherencia = $("#GRID_incoherencias").rup_grid("getRowData",numFila);
				varCodExpediente = filaIncoherencia['codExpediente'];
				
				$.rup_ajax({
					url : $.rup.CTX_PATH+"incoherencias/deshabilitar",
				    type: 'GET',
					data: {codExpediente: varCodExpediente},
					success: function(resultado, ajaxOptions) {
						$("#feedbackMensajesTablaIncoherencias").rup_feedback("set", $.rup.i18n.app.mensajes.ok.incoherencia_deshabilitada_ok, "ok");
						//Recargamos la tabla haciendo la petición al servidor
						$("#GRID_incoherencias").rup_grid("reloadGrid");
					},
					error: function(xhr, ajaxOptions, thrownError) {
						$("#feedbackMensajesTablaIncoherencias").rup_feedback("set", thrownError, "error");
					}
				});
			} 
		}
	} else {
		$("#feedbackMensajesTablaIncoherencias").rup_feedback("set", $.rup.i18n.app.mensajes.alert.debe_seleccionar_registro, "alert");
	}
}